# PHP Google SSO Project

This project implements Google login Single Sign-On (SSO) using OAuth 2.0, allowing users to log in with their Google accounts. The login data is recorded in a phpMyAdmin database.

## Project Structure

```
php-google-sso
├── src
│   ├── config
│   │   └── database.php
│   ├── controllers
│   │   └── AuthController.php
│   ├── models
│   │   └── User.php
│   ├── views
│   │   ├── login.php
│   │   └── dashboard.php
│   └── google-callback.php
├── public
│   └── index.php
├── composer.json
└── README.md
```

## Setup Instructions

1. **Clone the Repository**
   Clone this repository to your local machine using:
   ```
   git clone <repository-url>
   ```

2. **Install Dependencies**
   Navigate to the project directory and run:
   ```
   composer install
   ```
   This will install the required dependencies, including the Google API Client Library.

3. **Database Configuration**
   Open `src/config/database.php` and configure your database connection settings:
   - Host
   - Username
   - Password
   - Database Name

4. **Google Cloud Console Setup**
   - Go to the [Google Cloud Console](https://console.cloud.google.com/).
   - Create a new project.
   - Enable the Google+ API and the Google People API.
   - Create OAuth 2.0 credentials and set the redirect URI to `http://your-domain.com/google-callback.php`.
   - Download the credentials JSON file and place it in the project directory.

5. **Run the Application**
   - Start your local server (e.g., using XAMPP, MAMP, or built-in PHP server).
   - Access the application via `http://localhost/php-google-sso/public/index.php`.

## Usage Guidelines

- Navigate to the login page to log in with your Google account.
- After successful authentication, you will be redirected to the dashboard where you can see your user information.
- You can log out from the dashboard.

## License

This project is licensed under the MIT License. See the LICENSE file for more details.