<?php

namespace App\Controllers;

use App\Models\User;
use Google\Client;
use Google\Service\Oauth2;

class AuthController
{
    private $client;

    public function __construct()
    {
        $this->client = new Client();
        $this->client->setClientId('575962540307-sug5snc4hoo8ol6dt7gj99kh8vkcc8sg.apps.googleusercontent.com');
        $this->client->setClientSecret('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');
        $this->client->setRedirectUri('https://codeintern.test.smtchs.org/php-google-sso-2/index.php?action=callback');
        $this->client->addScope('email');
        $this->client->addScope('profile');
    }

    public function loginWithGoogle()
    {
        $authUrl = $this->client->createAuthUrl();
        header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));
        exit();
    }

    public function handleGoogleCallback()
    {
        if (isset($_GET['code'])) {
            $token = $this->client->fetchAccessTokenWithAuthCode($_GET['code']);
            $this->client->setAccessToken($token['access_token']);

            $oauth2 = new Oauth2($this->client);
            $userInfo = $oauth2->userinfo->get();

            $user = new User();
            $existingUser = $user->findUserByEmail($userInfo->email);

            if (!$existingUser) {
                $user->createUser($userInfo->name, $userInfo->email);
            }

            // Set user session or any other logic after login
            $_SESSION['user'] = [
                'id' => $existingUser ? $existingUser->id : $user->id,
                'name' => $userInfo->name,
                'email' => $userInfo->email,
            ];

            header('Location: /dashboard.php');
            exit();
        }
    }
}